/*
 i-net software provides programming examples for illustration only, without warranty
 either expressed or implied, including, but not limited to, the implied warranties
 of merchantability and/or fitness for a particular purpose. This programming example
 assumes that you are familiar with the programming language being demonstrated and
 the tools used to create and debug procedures. i-net software support professionals
 can help explain the functionality of a particular procedure, but they will not modify
 these examples to provide added functionality or construct procedures to meet your
 specific needs.
  
  i-net software 1998-2013

*/
namespace Inet.Viewer.Helper
{
    using System.Collections;
    using System.Text;

    /// <summary>
    /// Implementation of the Java Class String Tokenizer
    /// </summary>
    public class StringTokenizer
    {
        private string[] parts;
        private int i = 0;

        /// <summary>
        /// 
        /// </summary>
        /// <param name="str">The string that is to be splitted</param>
        /// <param name="delimiters">list of characters that are used as delimiters</param>
        public StringTokenizer(string str, string delimiters)
            : this(str, delimiters, false)
        {
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="str">The string that is to be splitted</param>
        /// <param name="delimiters">list of characters that are used as delimiters</param>
        /// <param name="flag"></param>
        public StringTokenizer(string str, string delimiters, bool flag)
        {
            char[] chars = Encoding.UTF8.GetChars(Encoding.UTF8.GetBytes(delimiters));
            string[] splitted = Split(str, chars, true);

            ArrayList list = new ArrayList();
            for (int i = 0; i < splitted.Length; i++)
            {
                if (splitted[i].Length != 0)
                {
                    list.Add(splitted[i]);
                }
            }

            parts = (string[])list.ToArray(typeof(string));
        }

        /// <summary>
        /// check if there are more tokens
        /// </summary>
        /// <returns></returns>
        public bool HasMore()
        {
            return i < parts.Length;
        }

        /// <summary>
        /// returns the next delimiter
        /// </summary>
        /// <returns></returns>
        public string Next()
        {
            return parts[i++];
        }

        /// <summary>
        /// The amount of 
        /// </summary>
        public int Length
        {
            get
            {
                return parts.Length;
            }
        }

        /// <summary>
        /// Implements the splitting that can include the delimiters
        /// </summary>
        /// <param name="str">The string that is to be splitted</param>
        /// <param name="delimiters">list of characters that are used as delimiters</param>   
        /// <param name="returnDelimters"></param>
        /// <returns>A string array with the splitted strings, including the delimiters</returns>
        public string[] Split(string str, char[] delimiters, bool returnDelimters)
        {
            ArrayList split = new ArrayList();
            int index = str.IndexOfAny(delimiters);

            while ((index >= 0) && (index < str.Length))
            {
                if (index >= 0 && index < str.Length)
                {
                    if (index == 0)
                    {
                        // starts with a delimiter
                        string part = str.Substring(0, 1);
                        if (returnDelimters)
                        {
                            split.Add(part);
                        }
                        str = str.Substring(1);
                    }
                    else
                    {
                        string part = str.Substring(0, index);
                        split.Add(part);
                        str = str.Substring(index);
                    }
                }
                index = str.IndexOfAny(delimiters);
                if (index < 0)
                { // to add the rest of the string
                    split.Add(str);
                }
            }
            return split.ToArray(typeof(string)) as string[];
        }
    }
}